<?php

include_once 'conexao.php';
 
class ModeloCandidatoVaga 
{     
	static public function mdlAddCandidatoVaga($dados){ 
  
		$stmt = Conexao::conectar()->prepare("INSERT INTO candidatovaga 
						(estado, idCandidato, dataCadastro,idVaga) VALUES (:estado, :idCandidato, :dataCadastro,:idVaga)");
		$stmt->bindParam(":idVaga", $dados["idVaga"], PDO::PARAM_STR);
		$stmt->bindParam(":estado", $dados["estado"], PDO::PARAM_STR);
		$stmt->bindParam(":dataCadastro", $dados["dataCadastro"], PDO::PARAM_STR);
		$stmt->bindParam(":idCandidato", $dados["idUsuario"], PDO::PARAM_STR);
 
		if($stmt->execute()){
			return "ok";
		}else{
			return "error";
		}

	}
 
	static public function mdlMostrarCandidatoNaVagaPorIdCandidatoEidVaga($idVaga,$idCandidato) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM candidatovaga where idVaga = :idVaga and idCandidato = :idCandidato");
			$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
			$stmt->bindParam(":idCandidato", $idCandidato, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarTodosConcorrentesDaVagaEidVaga($idVaga) {

		$resultado = array(); 

		$stmt = Conexao::conectar()->prepare("SELECT * FROM candidatovaga where idVaga = :idVaga");
		$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
		$stmt ->execute();

		$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;

	}

	static public function mdlMostrarTodosAlunosQuePagaramOuNaoPagaramOCertificadoPorIdVaga($idVaga,$estadoDoPagamentoCertificado) {

		$resultado = array();  

		$stmt = Conexao::conectar()->prepare("SELECT * FROM candidatovaga where idVaga = :idVaga and estadoDoPagamentoCertificado = :estadoDoPagamentoCertificado");
		$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
		$stmt->bindParam(":estadoDoPagamentoCertificado", $estadoDoPagamentoCertificado, PDO::PARAM_STR);
		$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}
 
	static public function mdlMostrarTodosVagasDoConcorrentesPoridCandidato($idCandidato) { 

		$resultado = array(); 

		$stmt = Conexao::conectar()->prepare("SELECT * FROM candidatovaga where idCandidato = :idCandidato");
		$stmt->bindParam(":idCandidato", $idCandidato, PDO::PARAM_STR);
		$stmt ->execute();

		$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;

	}
	 

	static public function mdlMostrarTodosCandidatos() {

		$resultado = array();

		$stmt = Conexao::conectar()->prepare("SELECT * FROM candidatovaga");
		$stmt ->execute();

		$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;

	}

	static public function mdlActualizarEstadoCandidatoVagaPoridVagaEidCandidato($idVaga, $idCandidato, $estado) {

		$stmt = Conexao::conectar()->query("UPDATE candidatovaga SET estado = '$estado' where idVaga = '$idVaga' AND idCandidato = '$idCandidato' "); 
			#$stmt ->execute();

	}

	

	static public function mdlActualizarValorPagoPeloCertificadoEDoEstadoDoPagamentoDoCertificadoCandidatoVagaPoridVagaEidCandidato($idVaga, $idCandidato, $valorPagoCertificado,$estadoDoPagamentoCertificado) {

		$stmt = Conexao::conectar()->query("UPDATE candidatovaga SET valorPagoCertificado = '$valorPagoCertificado', estadoDoPagamentoCertificado = '$estadoDoPagamentoCertificado' where idVaga = '$idVaga' AND idCandidato = '$idCandidato' "); 
		#$stmt ->execute();

}

	

	static public function mdlEliminarLikeDoEventoPorIdLike($id, $idUsuario){
 
		$stmt = Conexao::conectar()->prepare("DELETE FROM eventolikes where idEvento = :id and idUsuario = :idUsuario");
		$stmt->bindParam(":id", $id, PDO::PARAM_STR);
		$stmt->bindParam(":idUsuario", $idUsuario, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}

	}

}



?>